<?php $__env->startSection('title', 'Contact Messages'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Contact Messages</h1>
</div>

<div class="card">
    <div class="card-body">
        <?php if($messages->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Subject</th>
                        <th>Message</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="<?php echo e(!$message->is_read ? 'table-warning' : ''); ?>">
                        <td><?php echo e($message->name); ?></td>
                        <td><?php echo e($message->email); ?></td>
                        <td><?php echo e($message->subject ?? 'No subject'); ?></td>
                        <td><?php echo e(Str::limit($message->message, 50)); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($message->is_read ? 'success' : 'warning'); ?>">
                                <?php echo e($message->is_read ? 'Read' : 'Unread'); ?>

                            </span>
                        </td>
                        <td><?php echo e($message->created_at->format('M d, Y')); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.contact-messages.show', $message)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i> View
                            </a>
                            <form action="<?php echo e(route('admin.contact-messages.destroy', $message)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this message?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <p class="text-muted mb-0">No contact messages yet.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ Websites/ENT Care/resources/views/admin/contact-messages/index.blade.php ENDPATH**/ ?>